clear all
capture log close
program drop _all
set more off
snapshot erase _all
sysdir set PLUS "V:/bseidel/Ado\Plus"
set scheme graphscheme
graph set window fontface "Calibri"
set seed 23423

*** Comparing Survey Means and National Accounts.do
*** Brina Seidel


*************************************************************************************
*************************************************************************************
*************************************************************************************
*** Updating Elephant Chart.do
*** Brina Seidel
*** February 2018
***
*** This program compares survey means and national accounts means for Figure B2.
*************************************************************************************
*************************************************************************************
*************************************************************************************

*** Set your working directory here
global directory = "xxxxxxxxxxxxxxxx"
cd "$directory"

*** This will re-set your PLUS folder so that you can use our custom graph scheme. You may wish to note down your current PLUS folder so that you can change it back when you are done with this program (type "sysdir list" in the command window)
sysdir set PLUS "$directory/Ado\Plus"

*** Set graph scheme
set scheme graphscheme
graph set window fontface "Calibri"

*** Install user-written SSC programs 
ssc install wbopendata

*****************************************************************
*****************************************************************
*** Prepare the data
*****************************************************************
*****************************************************************

**************************************
*** Read in the data
**************************************
use "Input Data/Survey Means and National Accounts Means.dta", clear

**************************************
*** Keep most recent year with survey and HFCE data
**************************************
keep if hfce_pc < . & surveymean < .
sort countryname year
by countryname: keep if _n == _N
isid countryname
tab year

*** Keep only years after 2000
keep if year >= 2000 
quietly tab countryname
return list

*****************************************************************
*****************************************************************
*** Compare survey means and HFCE
*****************************************************************
*****************************************************************

**************************************
*** Calculate survey mean as a % of HFCE
**************************************
gen surveymean_pct = surveymean/hfce_pc * 100
gen hfce_bigger = surveymean_pct < 100 & surveymean_pct < .
tab hfce_bigger, m

**************************************
*** Plot (for countries with populatoin over 5000000 only, just to keep the graph legible)
**************************************
count if pop > 5000000

graph hbar surveymean_pct if pop > 5000000, over(countryname, sort(surveymean_pct) label(angle() labsize(vsmall) labgap(.65))) yline(100) ytitle("Percent of HFCE Captured By Survey") yscale(noline) ytick(, notick) ///
	xsize(7) ysize(11) plotregion(margin(zero))
graph export "Graphs/Figure B2.pdf", replace
graph export "Graphs/Figure B2.eps", replace
